﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Security.Cryptography.X509Certificates;
using Kz.GammaTech.Cms;
using Kz.GammaTech.X509;
using System.Collections;
using Kz.GammaTech.TSA;
using Kz.GammaTech.Asn1;
using Kz.GammaTech.CPWrapper;
using Kz.GammaTech.Crypto;
using Kz.GammaTech.OCSP;
using X509Certificate = Kz.GammaTech.X509.X509Certificate;

namespace Test_GammaEnvelopedCMS
{
    internal class Program
    {
        static void Main(string[] args)
        {
            // выбираем свой сертификат
            GammaEnvelopedCMS g_cms = new GammaEnvelopedCMS(true);
            g_cms.profile = new Kz.GammaTech.Crypto.TumarProfile("profile://VTEST.NATTEST7");//("profile://sender");
            g_cms.sender_cert = g_cms.profile.keys[0].x509Certificate;

            // добавляем сертификат получателя
            FileStream f_cert = new FileStream("certExch.cer", FileMode.Open);
            byte[] cert_b = new byte[f_cert.Length];
            f_cert.Read(cert_b, 0, cert_b.Length);
            f_cert.Close();

            X509CertificateParser parser = new X509CertificateParser();
            g_cms.responder_cert = parser.ReadCertificate(cert_b);

            FileStream f;
            ////Time stamp protocol (протокол штампа времени) или TSP
            //f = new FileStream("tsp.resp", FileMode.Open);
            //byte[] tsp_blob = new byte[f.Length];
            //f.Read(tsp_blob, 0, tsp_blob.Length);
            //f.Close();

            ////Протокол состояния сетевого сертификата (Online Certificate Status Protocol - OCSP)
            //f = new FileStream("ocsp.resp", FileMode.Open);
            //byte[] ocsp_blob = new byte[f.Length];
            //f.Read(ocsp_blob, 0, ocsp_blob.Length);
            //f.Close();

            //// опционально добавляем атрибуты
            //g_cms.AddTSP(tsp_blob);
            //g_cms.AddOCSP(ocsp_blob);
            //g_cms.AddSigningTime(); // now
            // 

            // шифруем
            byte[] msgBytes = System.Text.Encoding.UTF8.GetBytes("qwerty");
            byte[] enc_text = g_cms.Encrypt(msgBytes);

            //-------------------------------------------------

            //// получатель указывает свой профайл для расшифровки
            GammaEnvelopedCMS g_cms_d = new GammaEnvelopedCMS(false);
            g_cms_d.profile = new Kz.GammaTech.Crypto.TumarProfile("profile://VTEST.NATTEST8");//("profile://responder");

            // и расшифровывает
            string decrypted_text = System.Text.Encoding.UTF8.GetString(g_cms_d.Decrypt(enc_text));
            Console.WriteLine(decrypted_text);

            // разбираем атрибуты

            Hashtable attrTable = g_cms_d.attributes;
            ICollection keys = attrTable.Keys;
            foreach (DerObjectIdentifier s in keys)
            {
                if (s.Id == "1.2.840.113549.1.9.16.2.14") // tsp
                {
                    f = new FileStream(@"f:\Temp\12345\tsp.cer", FileMode.Open);
                    byte[] tsp_ca = new byte[f.Length];
                    f.Read(tsp_ca, 0, tsp_ca.Length);
                    f.Close();

                    // проверяем и парсим квитанцию TSP
                    TSPResponce tsp_stamp = new TSPResponce(attrTable[s], tsp_ca);
                    Console.WriteLine(System.Text.Encoding.ASCII.GetString(tsp_stamp.GetServerCertDN()));
                }
                if (s.Id == "1.3.6.1.5.5.7.48.1.1") // ocsp
                {
                    OCSPResponce ocsp_resp = new OCSPResponce(attrTable[s]);
                    Console.WriteLine("OCSP cert status " + ocsp_resp.Status.ToString());
                }
            }
            Console.Read();
        }
    }
}
